// Purchase Notification System with 200 Bangladeshi Names
const purchaseNames = [
    "Md. Sarif Mia", "Rakibul Hasan", "Tanvir Ahmed", "Md. Rafiqul Islam", "Shakil Ahmed",
    "Jahangir Alam", "Md. Shahidul Islam", "Nazmul Hasan", "Farhan Rahman", "Abdul Karim",
    "Md. Monir Hossain", "Sohel Rana", "Md. Rashed Khan", "Imran Hossain", "Zahid Hasan",
    "Md. Nasir Uddin", "Kamrul Islam", "Md. Arif Hossain", "Sumon Ahmed", "Md. Asaduzzaman",
    "Masud Rana", "Md. Sabbir Hossain", "Rubel Mia", "Md. Habibur Rahman", "Faisal Ahmed",
    "Md. Shahinur Rahman", "Aminul Islam", "Md. Mizanur Rahman", "Hasan Mahmud", "Md. Billal Hossain",
    "Rayhan Ahmed", "Md. Shafiqul Islam", "Emon Hossain", "Md. Mamun Hossain", "Alamin Hossain",
    "Md. Faruk Ahmed", "Sajjad Hossain", "Md. Nurul Islam", "Raju Ahmed", "Md. Jakir Hossain",
    "Shamim Hossain", "Md. Ashraful Islam", "Biplob Hossain", "Md. Saidul Islam", "Tanjir Ahmed",
    "Md. Mostofa Kamal", "Ripon Hossain", "Md. Anisur Rahman", "Palash Mia", "Md. Jamal Uddin",
    "Touhid Hasan", "Md. Liton Mia", "Kawsar Ahmed", "Md. Alamgir Hossain", "Roman Mia",
    "Md. Shohag Mia", "Minhaj Uddin", "Md. Selim Reza", "Jewel Rana", "Md. Saiful Islam",
    "Mahfuz Rahman", "Md. Rezaul Karim", "Iqbal Hossain", "Md. Hanif Mia", "Shanto Ahmed",
    "Md. Ashik Mia", "Babul Hossain", "Md. Tarikul Islam", "Suman Mia", "Md. Zahir Uddin",
    "Helal Uddin", "Md. Rahim Uddin", "Shohel Mia", "Md. Belal Hossain", "Rasel Ahmed",
    "Md. Kabir Hossain", "Nayeem Ahmed", "Md. Hafizur Rahman", "Robin Mia", "Md. Farid Hossain",
    "Tareq Hasan", "Md. Golam Mostafa", "Prince Hossain", "Md. Abdur Rahim", "Shimul Mia",
    "Md. Rashidul Islam", "Badsha Mia", "Md. Shariful Islam", "Jahid Hasan", "Md. Mahbubur Rahman",
    "Azad Mia", "Md. Khairul Islam", "Sakib Ahmed", "Md. Tofazzal Hossain", "Hasib Rahman",
    "Md. Nazmul Hoque", "Dulal Mia", "Md. Ashikur Rahman", "Belal Ahmed", "Md. Mozammel Haque",
    "Firoz Ahmed", "Md. Sohel Rana", "Rakib Hasan", "Md. Atiqur Rahman", "Shaon Ahmed",
    "Md. Zahidul Islam", "Milon Mia", "Md. Rafiq Uddin", "Naim Ahmed", "Md. Abdul Motin",
    "Jibon Mia", "Md. Khokon Mia", "Nahid Hasan", "Md. Ohidul Islam", "Sazid Ahmed",
    "Md. Bulbul Ahmed", "Polash Ahmed", "Md. Shahjalal", "Arman Hossain", "Md. Ruhul Amin",
    "Shafiq Ahmed", "Md. Abdul Halim", "Sojib Mia", "Md. Monwar Hossain", "Shahin Alam",
    "Md. Jashim Uddin", "Nadim Hasan", "Md. Siraj Uddin", "Tushar Ahmed", "Md. Abdul Barek",
    "Kabir Ahmed", "Md. Salauddin", "Rifat Hasan", "Md. Lutfor Rahman", "Akash Mia",
    "Md. Shamsul Alam", "Sadik Hasan", "Md. Abdul Momen", "Faysal Hossain", "Md. Nazrul Islam",
    "Masum Ahmed", "Md. Monjur Alam", "Jony Mia", "Md. Faruq Ahmed", "Sohan Ahmed",
    "Md. Abdus Samad", "Hiron Mia", "Md. Enamul Haque", "Tanveer Ahmed", "Md. Shamsuzzaman",
    "Anik Ahmed", "Md. Alamgir Kabir", "Rony Mia", "Md. Golam Rabbani", "Shopon Ahmed",
    "Md. Abdur Rahman", "Liton Ahmed", "Md. Mojibur Rahman", "Mehedi Hasan", "Md. Abdul Aziz",
    "Fahim Ahmed", "Md. Motaleb Hossain", "Shipon Mia", "Md. Khorshed Alam", "Anwar Hossain",
    "Md. Matiur Rahman", "Tuhin Ahmed", "Md. Abul Kashem", "Sohag Mia", "Md. Wahiduzzaman",
    "Parvez Ahmed", "Md. Shakhawat Hossain", "Kamal Hossain", "Md. Abdus Sattar", "Rokon Mia",
    "Md. Jahangir Kabir", "Delwar Hossain", "Md. Abdul Wahab", "Dipu Mia", "Md. Ziaur Rahman",
    "Hridoy Ahmed", "Md. Rony Mia", "Sujon Ahmed", "Md. Abdul Kader", "Jabed Mia",
    "Md. Obaidul Haque", "Sobuj Mia", "Md. Forkan Hossain", "Billah Ahmed", "Md. Shafiul Alam"
];

const purchaseTimes = [
    "এইমাত্র", "১ মিনিট আগে", "২ মিনিট আগে", "৩ মিনিট আগে", "৪ মিনিট আগে",
    "৫ মিনিট আগে", "৬ মিনিট আগে", "৮ মিনিট আগে", "১০ মিনিট আগে", "১২ মিনিট আগে"
];

let notificationTimeout;
let notificationInterval;

function getRandomName() {
    return purchaseNames[Math.floor(Math.random() * purchaseNames.length)];
}

function getRandomTime() {
    return purchaseTimes[Math.floor(Math.random() * purchaseTimes.length)];
}

function showNotification() {
    const notification = document.getElementById('purchaseNotification');
    const nameEl = document.getElementById('purchaseName');
    const timeEl = document.getElementById('purchaseTime');
    
    if (!notification || !nameEl || !timeEl) return;
    
    nameEl.textContent = getRandomName();
    timeEl.textContent = getRandomTime();
    
    notification.classList.add('show');
    
    // Hide after 25 seconds (before next one appears)
    notificationTimeout = setTimeout(() => {
        notification.classList.remove('show');
    }, 25000);
}

function hideNotification() {
    const notification = document.getElementById('purchaseNotification');
    if (notification) {
        notification.classList.remove('show');
    }
    if (notificationTimeout) {
        clearTimeout(notificationTimeout);
    }
}

function startNotificationSystem() {
    // Show first notification after 3 seconds
    setTimeout(() => {
        showNotification();
        
        // Then show every 30 seconds
        notificationInterval = setInterval(() => {
            showNotification();
        }, 30000);
    }, 3000);
}

// Initialize all functionality on page load
document.addEventListener('DOMContentLoaded', function() {
    startNotificationSystem();
    
    // Module Toggle Functionality
    document.querySelectorAll('.module-header').forEach(header => {
        header.addEventListener('click', function() {
            const content = this.nextElementSibling;
            const toggle = this.querySelector('.module-toggle');
            
            // Close all other modules
            document.querySelectorAll('.module-content').forEach(el => {
                if (el !== content) {
                    el.classList.remove('active');
                    el.previousElementSibling.querySelector('.module-toggle').classList.remove('active');
                }
            });
            
            // Toggle current module
            content.classList.toggle('active');
            toggle.classList.toggle('active');
        });
    });

    // FAQ Toggle Functionality
    document.querySelectorAll('.faq-question').forEach(question => {
        question.addEventListener('click', function() {
            const answer = this.nextElementSibling;
            const toggle = this.querySelector('.faq-toggle');
            
            // Close all other FAQs
            document.querySelectorAll('.faq-answer').forEach(el => {
                if (el !== answer) {
                    el.classList.remove('active');
                    el.previousElementSibling.querySelector('.faq-toggle').classList.remove('active');
                }
            });
            
            // Toggle current FAQ
            answer.classList.toggle('active');
            toggle.classList.toggle('active');
        });
    });
});

// Smooth Scroll for anchor links
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function(e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Form Validation
const form = document.getElementById('enrollmentForm');
if (form) {
    form.addEventListener('submit', function(e) {
        const name = document.getElementById('name').value.trim();
        const email = document.getElementById('email').value.trim();
        const phone = document.getElementById('phone').value.trim();
        
        if (!name || !email || !phone) {
            e.preventDefault();
            alert('দয়া করে সকল ফিল্ড পূরণ করুন');
            return;
        }
        
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(email)) {
            e.preventDefault();
            alert('দয়া করে সঠিক ইমেইল দিন');
            return;
        }
        
        // Form will submit normally to process_order.php
    });
}

// Countdown Timer - Live countdown from 13 days 4 hours
function startCountdown() {
    const daysEl = document.getElementById('timer-days');
    const hoursEl = document.getElementById('timer-hours');
    const minutesEl = document.getElementById('timer-minutes');
    const secondsEl = document.getElementById('timer-seconds');
    
    if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;
    
    // Check if we have a saved end date in localStorage
    let endDate;
    const savedEndDate = localStorage.getItem('countdownEndDate');
    
    if (savedEndDate) {
        endDate = new Date(savedEndDate);
    } else {
        // Set countdown: 13 days and 4 hours from now
        endDate = new Date();
        endDate.setDate(endDate.getDate() + 13);
        endDate.setHours(endDate.getHours() + 4);
        localStorage.setItem('countdownEndDate', endDate.toISOString());
    }
    
    function updateTimer() {
        const now = new Date();
        const distance = endDate - now;
        
        if (distance < 0) {
            // Timer expired
            daysEl.textContent = '00';
            hoursEl.textContent = '00';
            minutesEl.textContent = '00';
            secondsEl.textContent = '00';
            return;
        }
        
        const days = Math.floor(distance / (1000 * 60 * 60 * 24));
        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);
        
        daysEl.textContent = String(days).padStart(2, '0');
        hoursEl.textContent = String(hours).padStart(2, '0');
        minutesEl.textContent = String(minutes).padStart(2, '0');
        secondsEl.textContent = String(seconds).padStart(2, '0');
    }
    
    // Update immediately
    updateTimer();
    
    // Update every second
    setInterval(updateTimer, 1000);
}

// Initialize countdown on page load
document.addEventListener('DOMContentLoaded', function() {
    startCountdown();
});

// Scroll to top button
const scrollToTopBtn = document.getElementById('scrollToTopBtn');
if (scrollToTopBtn) {
    window.addEventListener('scroll', () => {
        if (window.pageYOffset > 300) {
            scrollToTopBtn.style.display = 'block';
        } else {
            scrollToTopBtn.style.display = 'none';
        }
    });
    
    scrollToTopBtn.addEventListener('click', () => {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });
}

// Mobile menu toggle
const mobileMenuBtn = document.getElementById('mobileMenuBtn');
const navLinks = document.querySelector('.nav-links');
if (mobileMenuBtn) {
    mobileMenuBtn.addEventListener('click', () => {
        navLinks.classList.toggle('active');
    });
}

// Features Slider - Auto slide for mobile
function initFeaturesSlider(sliderId, dotsId) {
    const slider = document.getElementById(sliderId);
    const dots = document.querySelectorAll('#' + dotsId + ' .dot');
    
    if (!slider || !dots.length) return;
    
    let currentSlide = 0;
    const totalSlides = dots.length;
    let autoSlideInterval;
    
    function goToSlide(index) {
        currentSlide = index;
        const cards = slider.querySelectorAll('.feature-card');
        if (cards[index]) {
            // Use scrollLeft instead of scrollIntoView to prevent page scroll
            const cardWidth = cards[index].offsetWidth + 16; // card width + margin
            slider.scrollTo({
                left: index * cardWidth,
                behavior: 'smooth'
            });
        }
        updateDots();
    }
    
    function updateDots() {
        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === currentSlide);
        });
    }
    
    function nextSlide() {
        currentSlide = (currentSlide + 1) % totalSlides;
        goToSlide(currentSlide);
    }
    
    function startAutoSlide() {
        if (window.innerWidth <= 768) {
            autoSlideInterval = setInterval(nextSlide, 3000);
        }
    }
    
    function stopAutoSlide() {
        clearInterval(autoSlideInterval);
    }
    
    // Dot click navigation
    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            stopAutoSlide();
            goToSlide(index);
            startAutoSlide();
        });
    });
    
    // Update current slide based on scroll position
    slider.addEventListener('scroll', () => {
        const cards = slider.querySelectorAll('.feature-card');
        if (!cards.length) return;
        
        const cardWidth = cards[0].offsetWidth + 16;
        const scrollPos = slider.scrollLeft;
        const newSlide = Math.round(scrollPos / cardWidth);
        
        if (newSlide !== currentSlide && newSlide >= 0 && newSlide < totalSlides) {
            currentSlide = newSlide;
            updateDots();
        }
    });
    
    // Touch events to pause auto-slide
    slider.addEventListener('touchstart', stopAutoSlide);
    slider.addEventListener('touchend', () => {
        setTimeout(startAutoSlide, 3000);
    });
    
    // Start auto slide on mobile
    startAutoSlide();
    
    // Handle resize
    window.addEventListener('resize', () => {
        stopAutoSlide();
        if (window.innerWidth <= 768) {
            startAutoSlide();
        }
    });
}

// Initialize slider on page load
document.addEventListener('DOMContentLoaded', function() {
    initFeaturesSlider('featuresSlider', 'sliderDots');
    initFeaturesSlider('featuresSlider2', 'sliderDots2');
    initFeaturesSlider('featuresSlider3', 'sliderDots3');
    initFeaturesSlider('featuresSlider4', 'sliderDots4');
});
