<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orderId = sanitize($_POST['order_id'] ?? '');
    $gatewayId = intval($_POST['gateway_id'] ?? 0);
    
    if (empty($orderId) || $gatewayId <= 0) {
        header('Location: index.php?error=invalid_request');
        exit;
    }
    
    try {
        // Verify order exists and is pending
        $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ? AND payment_status = 'pending'");
        $stmt->execute([$orderId]);
        $order = $stmt->fetch();
        
        if (!$order) {
            header('Location: index.php?error=order_not_found');
            exit;
        }
        
        // Get gateway details
        $stmt = $pdo->prepare("SELECT * FROM payment_gateways WHERE id = ? AND status = 1");
        $stmt->execute([$gatewayId]);
        $gateway = $stmt->fetch();
        
        if (!$gateway) {
            header('Location: payment.php?order=' . $orderId . '&error=gateway_not_found');
            exit;
        }
        
        // Update order with selected gateway
        $stmt = $pdo->prepare("UPDATE orders SET payment_gateway_id = ?, payment_method = ? WHERE order_id = ?");
        $stmt->execute([$gatewayId, $gateway['name'], $orderId]);
        
        // Check gateway type
        if ($gateway['type'] === 'automatic' && $gateway['gateway_type'] === 'bkash') {
            // Redirect to bKash payment page (to be implemented)
            header('Location: bkash_payment.php?order=' . $orderId);
            exit;
        } else {
            // Redirect to manual payment page
            header('Location: manual_payment.php?order=' . $orderId . '&gateway=' . $gatewayId);
            exit;
        }
        
    } catch(PDOException $e) {
        error_log("Payment processing error: " . $e->getMessage());
        header('Location: payment.php?order=' . $orderId . '&error=system_error');
        exit;
    }
} else {
    header('Location: index.php');
    exit;
}
?>
