<?php
require_once 'config.php';

// Get order ID from URL
$orderId = $_GET['order'] ?? '';

if (empty($orderId)) {
    header('Location: index.php');
    exit;
}

// Fetch order details
try {
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ? AND payment_status = 'pending'");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order) {
        header('Location: index.php?error=order_not_found');
        exit;
    }
    
    // Get active payment gateways
    $gateways = getActiveGateways($pdo);
    
    // Get settings for Facebook Pixel
    $settings = getSettings($pdo);
    
} catch(PDOException $e) {
    die("Error loading payment page");
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট করুন - Prime Institute</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '1180786514222470');
    fbq('track', 'PageView');
    fbq('track', 'InitiateCheckout', {
        value: <?php echo $order['amount']; ?>,
        currency: 'BDT',
        content_name: 'AI Automation Course',
        content_ids: ['<?php echo $order['order_id']; ?>']
    });
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
    <style>
        .payment-container {
            max-width: 800px;
            margin: 80px auto 40px;
            padding: 20px;
        }
        .order-summary {
            background: white;
            border-radius: 16px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        .order-summary h2 {
            margin: 0 0 20px 0;
            color: #1f2937;
        }
        .order-info {
            display: grid;
            gap: 12px;
            margin-bottom: 20px;
        }
        .order-info-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .order-info-label {
            color: #6b7280;
            font-weight: 500;
        }
        .order-info-value {
            color: #1f2937;
            font-weight: 600;
        }
        .total-amount {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            margin-top: 20px;
        }
        .total-amount h3 {
            margin: 0 0 10px 0;
            font-size: 1.2rem;
        }
        .total-amount .amount {
            font-size: 2.5rem;
            font-weight: 800;
        }
        .payment-methods {
            background: white;
            border-radius: 16px;
            padding: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        .payment-methods h3 {
            margin: 0 0 20px 0;
            color: #1f2937;
        }
        .gateway-grid {
            display: grid;
            gap: 15px;
        }
        .gateway-card {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .gateway-card:hover {
            border-color: #667eea;
            background: #f9fafb;
        }
        .gateway-card.selected {
            border-color: #667eea;
            background: #eef2ff;
        }
        .gateway-icon {
            width: 60px;
            height: 60px;
            background: #f3f4f6;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        .gateway-info {
            flex: 1;
        }
        .gateway-name {
            font-weight: 600;
            font-size: 1.1rem;
            color: #1f2937;
            margin-bottom: 5px;
        }
        .gateway-type {
            color: #6b7280;
            font-size: 0.9rem;
        }
        .gateway-badge {
            background: #10b981;
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        .gateway-badge.manual {
            background: #f59e0b;
        }
        .gateway-badge.recommended {
            background: #e2136e;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        .gateway-card.bkash-card {
            border-color: #e2136e;
            background: linear-gradient(135deg, #fff5f8 0%, #fff 100%);
        }
        .gateway-card.bkash-card:hover {
            border-color: #e2136e;
            background: linear-gradient(135deg, #ffe8ef 0%, #fff5f8 100%);
        }
        .proceed-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            margin-top: 20px;
            transition: transform 0.2s;
        }
        .proceed-btn:hover {
            transform: translateY(-2px);
        }
        .proceed-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        .no-gateways {
            text-align: center;
            padding: 40px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <img src="logo.png" alt="Prime Institute" class="logo-img">
            </a>
        </div>
    </nav>

    <div class="payment-container">
        <div class="order-summary">
            <h2>📋 অর্ডার সামারি</h2>
            <div class="order-info">
                <div class="order-info-row">
                    <span class="order-info-label">অর্ডার আইডি</span>
                    <span class="order-info-value"><?php echo htmlspecialchars($order['order_id']); ?></span>
                </div>
                <div class="order-info-row">
                    <span class="order-info-label">নাম</span>
                    <span class="order-info-value"><?php echo htmlspecialchars($order['name']); ?></span>
                </div>
                <div class="order-info-row">
                    <span class="order-info-label">ইমেইল</span>
                    <span class="order-info-value"><?php echo htmlspecialchars($order['email']); ?></span>
                </div>
                <div class="order-info-row">
                    <span class="order-info-label">ফোন</span>
                    <span class="order-info-value"><?php echo htmlspecialchars($order['phone']); ?></span>
                </div>
            </div>
            <div class="total-amount">
                <h3>মোট পেমেন্ট</h3>
                <div class="amount">৳<?php echo number_format($order['amount'], 0); ?></div>
            </div>
        </div>

        <div class="payment-methods">
            <h3>💳 পেমেন্ট মেথড সিলেক্ট করুন</h3>
            
            <?php if (empty($gateways)): ?>
                <div class="no-gateways">
                    <p>দুঃখিত, এই মুহূর্তে কোনো পেমেন্ট মেথড উপলব্ধ নেই।</p>
                </div>
            <?php else: ?>
                <form id="paymentForm" method="POST" action="process_payment.php">
                    <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order['order_id']); ?>">
                    <input type="hidden" name="gateway_id" id="selectedGatewayId" value="">
                    
                    <div class="gateway-grid">
                        <?php 
                        // Sort gateways: bKash first, then others
                        usort($gateways, function($a, $b) {
                            $aIsBkash = (strtolower($a['gateway_type'] ?? '') === 'bkash') ? 0 : 1;
                            $bIsBkash = (strtolower($b['gateway_type'] ?? '') === 'bkash') ? 0 : 1;
                            return $aIsBkash - $bIsBkash;
                        });
                        ?>
                        <?php foreach ($gateways as $gateway): 
                            $isBkash = strtolower($gateway['gateway_type'] ?? '') === 'bkash';
                        ?>
                        <div class="gateway-card <?php echo $isBkash ? 'bkash-card' : ''; ?>" onclick="selectGateway(<?php echo $gateway['id']; ?>, '<?php echo htmlspecialchars($gateway['type']); ?>')">
                            <div class="gateway-icon">
                                <?php 
                                $icons = [
                                    'bkash' => '📱',
                                    'nagad' => '💰',
                                    'rocket' => '🚀',
                                    'bank' => '🏦',
                                    'default' => '💳'
                                ];
                                echo $icons[$gateway['gateway_type'] ?? 'default'] ?? $icons['default'];
                                ?>
                            </div>
                            <div class="gateway-info">
                                <div class="gateway-name"><?php echo htmlspecialchars($gateway['name']); ?></div>
                                <?php if (!empty($gateway['account_number'])): ?>
                                <div class="gateway-type">
                                    <?php echo htmlspecialchars($gateway['account_type'] ?? 'Account'); ?>: 
                                    <?php echo htmlspecialchars($gateway['account_number']); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php if ($isBkash): ?>
                            <span class="gateway-badge recommended">Recommended ⭐</span>
                            <?php else: ?>
                            <span class="gateway-badge <?php echo $gateway['type'] === 'manual' ? 'manual' : ''; ?>">
                                <?php echo $gateway['type'] === 'automatic' ? 'স্বয়ংক্রিয়' : 'ম্যানুয়াল'; ?>
                            </span>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <button type="submit" class="proceed-btn" id="proceedBtn" disabled>
                        🚀 পেমেন্ট সম্পন্ন করুন
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <script>
        let selectedGatewayId = null;
        
        function selectGateway(gatewayId, type) {
            // Remove previous selection
            document.querySelectorAll('.gateway-card').forEach(card => {
                card.classList.remove('selected');
            });
            
            // Add selection to clicked card
            event.currentTarget.classList.add('selected');
            
            // Store selected gateway
            selectedGatewayId = gatewayId;
            document.getElementById('selectedGatewayId').value = gatewayId;
            document.getElementById('proceedBtn').disabled = false;
        }
        
        document.getElementById('paymentForm')?.addEventListener('submit', function(e) {
            if (!selectedGatewayId) {
                e.preventDefault();
                alert('অনুগ্রহ করে একটি পেমেন্ট মেথড সিলেক্ট করুন');
            }
        });
    </script>
</body>
</html>
