<?php
require_once 'config.php';
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>প্রাইম ইনস্টিটিউট - Crypto Trading কোর্স</title>
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '1180786514222470');
    fbq('track', 'PageView');
    </script>
    <noscript>
    <img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"/>
    </noscript>
    <!-- End Meta Pixel Code -->
</head>
<body>
    <!-- Floating Crypto Background Icons -->
    <div class="crypto-bg-icons">
        <!-- Bitcoin Icons -->
        <svg class="crypto-icon btc-1" viewBox="0 0 32 32" fill="#6366f1">
            <path d="M16 0C7.163 0 0 7.163 0 16s7.163 16 16 16 16-7.163 16-16S24.837 0 16 0zm0 30C8.268 30 2 23.732 2 16S8.268 2 16 2s14 6.268 14 14-6.268 14-14 14zm2.5-21h-5v4h-2v2h2v8h-2v2h2v4h5c3.314 0 6-2.686 6-6 0-1.657-.672-3.157-1.757-4.243A5.978 5.978 0 0024.5 15c0-3.314-2.686-6-6-6zm0 16h-3v-4h3a2 2 0 110 4zm0-8h-3v-4h3a2 2 0 110 4z"/>
        </svg>
        <svg class="crypto-icon btc-2" viewBox="0 0 32 32" fill="#ec4899">
            <path d="M16 0C7.163 0 0 7.163 0 16s7.163 16 16 16 16-7.163 16-16S24.837 0 16 0zm0 30C8.268 30 2 23.732 2 16S8.268 2 16 2s14 6.268 14 14-6.268 14-14 14zm2.5-21h-5v4h-2v2h2v8h-2v2h2v4h5c3.314 0 6-2.686 6-6 0-1.657-.672-3.157-1.757-4.243A5.978 5.978 0 0024.5 15c0-3.314-2.686-6-6-6zm0 16h-3v-4h3a2 2 0 110 4zm0-8h-3v-4h3a2 2 0 110 4z"/>
        </svg>
        <svg class="crypto-icon btc-3" viewBox="0 0 32 32" fill="#8b5cf6">
            <path d="M16 0C7.163 0 0 7.163 0 16s7.163 16 16 16 16-7.163 16-16S24.837 0 16 0zm0 30C8.268 30 2 23.732 2 16S8.268 2 16 2s14 6.268 14 14-6.268 14-14 14zm2.5-21h-5v4h-2v2h2v8h-2v2h2v4h5c3.314 0 6-2.686 6-6 0-1.657-.672-3.157-1.757-4.243A5.978 5.978 0 0024.5 15c0-3.314-2.686-6-6-6zm0 16h-3v-4h3a2 2 0 110 4zm0-8h-3v-4h3a2 2 0 110 4z"/>
        </svg>
        <!-- Ethereum Icons -->
        <svg class="crypto-icon eth-1" viewBox="0 0 32 32" fill="#6366f1">
            <path d="M16 0l-16 16 16 16 16-16-16-16zm0 4.5l11.5 11.5-11.5 6.5-11.5-6.5 11.5-11.5zm0 23l-11.5-11.5 11.5 6.5 11.5-6.5-11.5 11.5z"/>
        </svg>
        <svg class="crypto-icon eth-2" viewBox="0 0 32 32" fill="#ec4899">
            <path d="M16 0l-16 16 16 16 16-16-16-16zm0 4.5l11.5 11.5-11.5 6.5-11.5-6.5 11.5-11.5zm0 23l-11.5-11.5 11.5 6.5 11.5-6.5-11.5 11.5z"/>
        </svg>
        <svg class="crypto-icon eth-3" viewBox="0 0 32 32" fill="#8b5cf6">
            <path d="M16 0l-16 16 16 16 16-16-16-16zm0 4.5l11.5 11.5-11.5 6.5-11.5-6.5 11.5-11.5zm0 23l-11.5-11.5 11.5 6.5 11.5-6.5-11.5 11.5z"/>
        </svg>
    </div>

    <!-- Purchase Notification Popup -->
    <div class="purchase-notification" id="purchaseNotification">
        <div class="purchase-notification-icon">🎉</div>
        <div class="purchase-notification-content">
            <div class="purchase-notification-name" id="purchaseName">Md. Sarif Mia</div>
            <div class="purchase-notification-text">Crypto Trading কোর্সে ভর্তি হয়েছেন</div>
            <div class="purchase-notification-time" id="purchaseTime">২ মিনিট আগে</div>
        </div>
        <button class="purchase-notification-close" onclick="hideNotification()">×</button>
    </div>

    <!-- Navigation Bar -->
    <nav class="navbar">
        <div class="navbar-container">
            <a href="#" class="logo">
                <img src="logo.png" alt="Prime Institute" class="logo-img">
            </a>
            <a href="#pricing" class="mobile-buy-btn" onclick="document.getElementById('pricing').scrollIntoView({behavior:'smooth'}); return false;">
                🛒 এখনই কিনুন
            </a>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-bg-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
        </div>
        <div class="hero-content">
            <span class="hero-badge">🎯 বাংলাদেশের #১ Crypto Trading কোর্স</span>
            <h1>Crypto Trading শিখে<br><span class="gradient-text">মাসে ১০-১৫%+ রিটার্ন</span> নিশ্চিত করুন</h1>
            <p>ঘরে বসে Crypto Trading মাস্টার করে নিয়মিত আয় শুরু করুন! ফিউচার ট্রেডিং, মানি ম্যানেজমেন্ট ও সিক্রেট স্ট্র্যাটেজি শিখুন।</p>
            <div class="hero-buttons">
                <button class="cta-button primary" onclick="document.getElementById('pricing').scrollIntoView({behavior:'smooth'})">
                    <span>🚀</span> এখনই শুরু করুন
                </button>
                <button class="cta-button secondary" onclick="document.getElementById('courses').scrollIntoView({behavior:'smooth'})">
                    <span>📖</span> কোর্স দেখুন
                </button>
            </div>
            <div class="hero-stats">
                <div class="stat-item">
                    <span class="stat-number">১০-১৫%+</span>
                    <span class="stat-label">মাসিক রিটার্ন</span>
                </div>
                <div class="stat-divider"></div>
                <div class="stat-item">
                    <span class="stat-number">৮+</span>
                    <span class="stat-label">মডিউল</span>
                </div>
                <div class="stat-divider"></div>
                <div class="stat-item">
                    <span class="stat-number">Lifetime</span>
                    <span class="stat-label">সাপোর্ট</span>
                </div>
            </div>
        </div>
        <div class="scroll-indicator">
            <div class="mouse"></div>
        </div>
    </section>

    <!-- Main Container -->
    <div class="container">
        <!-- Course Overview -->
        <section class="section" id="about">
            <div class="section-header">
                <span class="section-badge">কোর্স পরিচিতি</span>
                <h2>Crypto Trading মাস্টারক্লাস</h2>
                <p class="section-subtitle">বাংলাদেশের সবচেয়ে প্র্যাকটিক্যাল ক্রিপ্টো ট্রেডিং প্রোগ্রাম</p>
            </div>
            
            <div class="info-box">
                <h3>💰 ক্রিপ্টো ট্রেডিং কেন?</h3>
                <ul>
                    <li><strong>ঘরে বসে আয়:</strong> যেকোনো সময় যেকোনো জায়গা থেকে ট্রেড করুন</li>
                    <li><strong>উচ্চ রিটার্ন:</strong> সঠিক কৌশল অনুসরণ করে মাসে ১০-১৫%+ রিটার্ন সম্ভব</li>
                    <li><strong>স্বল্প পুঁজি:</strong> মাত্র $১০ দিয়েও শুরু করতে পারবেন</li>
                    <li><strong>২৪/৭ মার্কেট:</strong> দিন রাত যেকোনো সময় ট্রেডিং সুযোগ</li>
                </ul>
            </div>

            <div class="features-grid features-slider" id="featuresSlider">
                <div class="feature-card">
                    <div class="feature-icon">💡</div>
                    <h4>১০-১৫%+ মাসিক রিটার্ন</h4>
                    <p>প্রমাণিত কৌশল যা নিয়মিত মুনাফা নিশ্চিত করে</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🔧</div>
                    <h4>অ্যাডভান্সড মানি ম্যানেজমেন্ট</h4>
                    <p>মার্কেট ক্র্যাশেও পোর্টফোলিও সুরক্ষিত রাখুন</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🚀</div>
                    <h4>প্রিমিয়াম সিগন্যাল গ্রুপ</h4>
                    <p>প্রতিদিন বিশেষজ্ঞ সিগন্যাল এবং মার্কেট আপডেট</p>
                </div>
            </div>
            <div class="slider-dots" id="sliderDots">
                <span class="dot active"></span>
                <span class="dot"></span>
                <span class="dot"></span>
            </div>
        </section>

        <!-- Why Binance Section -->
        <section class="section section-alt">
            <div class="section-header">
                <span class="section-badge">কেন Crypto Trading?</span>
                <h2>Crypto Trading কেন সেরা পছন্দ?</h2>
            </div>

            <div class="info-box highlight-box">
                <h3>⚡ Crypto Trading কী?</h3>
                <ul>
                    <li>ডিজিটাল কারেন্সি ট্রেড করে মুনাফা অর্জন করার পদ্ধতি</li>
                    <li>৩০০+ ক্রিপ্টোকারেন্সিতে ট্রেড করার সুযোগ</li>
                    <li>স্পট ট্রেডিং, ফিউচার ট্রেডিং, স্টক ট্রেডিং সহ সব ফিচার</li>
                    <li>কম ফি এবং উচ্চ লিকুইডিটি</li>
                </ul>
            </div>

            <div class="comparison-cards">
                <div class="compare-card bad">
                    <div class="compare-header">
                        <span class="compare-icon">❌</span>
                        <h4>অন্যান্য প্ল্যাটফর্ম</h4>
                    </div>
                    <ul>
                        <li>কোন প্রিমিয়াম সিগন্যাল গ্রুপ নেই</li>
                        <li>উচ্চ ট্রেডিং ফি</li>
                        <li>কম লিকুইডিটি</li>
                    </ul>
                </div>
                <div class="compare-card good">
                    <div class="compare-header">
                        <span class="compare-icon">✅</span>
                        <h4>আমাদের কোর্স</h4>
                    </div>
                    <ul>
                        <li>Binance, Etoro, Exness সব প্ল্যাটফর্ম</li>
                        <li>সর্বনিম্ন ট্রেডিং ফি</li>
                        <li>সর্বোচ্চ লিকুইডিটি ও নিরাপত্তা</li>
                    </ul>
                </div>
            </div>

            
        </section>

        <!-- Trading Process -->
        <section class="section">
            <div class="section-header">
                <span class="section-badge">কিভাবে শুরু করবেন</span>
                <h2>ট্রেডিং শুরু করার ধাপসমূহ</h2>
            </div>
            
            <div class="steps-container">
                <div class="step-item">
                    <div class="step-number">০১</div>
                    <div class="step-content">
                        <h4>অ্যাকাউন্ট সেটআপ</h4>
                        <p>বাইনান্স অ্যাকাউন্ট তৈরি ও ভেরিফাই করুন</p>
                    </div>
                </div>
                <div class="step-item">
                    <div class="step-number">০২</div>
                    <div class="step-content">
                        <h4>ব্যাসিক শিখুন</h4>
                        <p>মার্কেট এনালাইসিস ও চার্ট রিডিং</p>
                    </div>
                </div>
                <div class="step-item">
                    <div class="step-number">০৩</div>
                    <div class="step-content">
                        <h4>কৌশল প্রয়োগ</h4>
                        <p>প্রাইস অ্যাকশন ও সিক্রেট স্ট্র্যাটেজি</p>
                    </div>
                </div>
                <div class="step-item">
                    <div class="step-number">০৪</div>
                    <div class="step-content">
                        <h4>লাভ করুন</h4>
                        <p>মাসে ১০-১৫%+ নিয়মিত রিটার্ন</p>
                    </div>
                </div>
            </div>

            <div class="examples-grid">
                <div class="example-card">
                    <span class="example-icon">📈</span>
                    <p>স্পট ট্রেডিং ⇒ নিরাপদ ও দীর্ঘমেয়াদী লাভ</p>
                </div>
                <div class="example-card">
                    <span class="example-icon">⚡</span>
                    <p>ফিউচার ট্রেডিং ⇒ হাই লিভারেজ ও দ্রুত মুনাফা</p>
                </div>
                <div class="example-card">
                    <span class="example-icon">💼</span>
                    <p>মানি ম্যানেজমেন্ট ⇒ ক্যাপিটাল সুরক্ষা</p>
                </div>
                <div class="example-card">
                    <span class="example-icon">📊</span>
                    <p>প্রাইস অ্যাকশন ⇒ মার্কেট মুভমেন্ট বুঝুন</p>
                </div>
                <div class="example-card">
                    <span class="example-icon">🎯</span>
                    <p>ডেইলি সিগন্যাল ⇒ প্রিমিয়াম গ্রুপ অ্যাক্সেস</p>
                </div>
                <div class="example-card">
                    <span class="example-icon">🔐</span>
                    <p>রিস্ক ম্যানেজমেন্ট ⇒ লস থেকে সুরক্ষা</p>
                </div>
            </div>
        </section>

        <!-- What You'll Learn -->
        <section class="section section-alt" id="courses">
            <div class="section-header">
                <span class="section-badge">কোর্স কন্টেন্ট</span>
                <h2>এই কোর্সে যা শিখবেন</h2>
            </div>
            
            <div class="learn-grid">
                <div class="learn-item">
                    <span class="learn-icon">📘</span>
                    <span>Crypto Trading মাস্টারক্লাস: অ্যাকাউন্ট সেটআপ থেকে ফান্ড সিকিউরিটি</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">⚡</span>
                    <span>ফিউচার ট্রেডিং স্ট্র্যাটেজি: হাই লিভারেজ ম্যানেজমেন্ট ও রিস্ক কমানোর কৌশল</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">💼</span>
                    <span>মানি ম্যানেজমেন্ট: ক্যাপিটাল সুরক্ষা এবং সর্বোচ্চ লাভের পদ্ধতি</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">📊</span>
                    <span>প্রাইস অ্যাকশন ও সিক্রেট স্ট্র্যাটেজি: ইন্ডিকেটর ছাড়াই মার্কেট রিডিং</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">🌐</span>
                    <span>মাল্টি-প্ল্যাটফর্ম গাইড: Binance, Etoro ও Exness মাস্টারি</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">🎯</span>
                    <span>প্রিমিয়াম সিগন্যাল গ্রুপ: ডেইলি ট্রেডিং সিগন্যাল ও মার্কেট আপডেট</span>
                </div>
            </div>

            <div class="features-grid features-slider" id="featuresSlider2">
                <div class="feature-card glass-card">
                    <div class="feature-number">৫০+</div>
                    <h4>রেকর্ডেড ভিডিও ক্লাস</h4>
                    <p>যেকোনো সময় শিখতে পারবেন</p>
                </div>
                <div class="feature-card glass-card">
                    <div class="feature-number">লাইভ</div>
                    <h4>সাপোর্ট সেশন</h4>
                    <p>নিয়মিত লাইভ সাপোর্ট ও QnA</p>
                </div>
                <div class="feature-card glass-card">
                    <div class="feature-number">১:১</div>
                    <h4>মেন্টরশিপ</h4>
                    <p>বিশেষজ্ঞ ট্রেডার সাপোর্ট</p>
                </div>
            </div>
            <div class="slider-dots" id="sliderDots2">
                <span class="dot active"></span>
                <span class="dot"></span>
                <span class="dot"></span>
            </div>
        </section>

        <!-- Course Modules -->
        <section class="section" id="modules">
            <div class="section-header">
                <span class="section-badge">সিলেবাস</span>
                <h2>কোর্স মডিউল সমূহ</h2>
                <p class="section-subtitle">৮ টি বিস্তারিত মডিউল রয়েছে</p>
            </div>

            <div class="module-list">
                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ১: Crypto Trading বেসিক ও একাউন্ট সেটআপ</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>Crypto Trading কী এবং কিভাবে শুরু করবেন</li>
                            <li>অ্যাকাউন্ট রেজিস্ট্রেশন ও KYC ভেরিফিকেশন</li>
                            <li>টু-ফ্যাক্টর অথেন্টিকেশন (2FA) সেটআপ</li>
                            <li>ডিপোজিট ও উইথড্র প্রসেস</li>
                            <li>ফান্ড সিকিউরিটি ও সেফটি টিপস</li>
                            <li>ওয়ালেট ম্যানেজমেন্ট</li>
                            <li>Binance, Etoro, Exness অ্যাপ ও ওয়েব ইন্টারফেস</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ২: ক্রিপ্টো ট্রেডিং ফান্ডামেন্টালস</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>ক্রিপ্টোকারেন্সি কী ও কিভাবে কাজ করে</li>
                            <li>মার্কেট ক্যাপ, ভলিউম ও লিকুইডিটি</li>
                            <li>বুল মার্কেট ও বিয়ার মার্কেট</li>
                            <li>স্পট ট্রেডিং vs ফিউচার ট্রেডিং</li>
                            <li>অর্ডার টাইপস: মার্কেট, লিমিট, স্টপ-লস</li>
                            <li>ট্রেডিং পেয়ার বুঝা (BTC/USDT, ETH/USDT)</li>
                            <li>চার্ট রিডিং বেসিক</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৩: টেকনিক্যাল এনালাইসিস</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>ক্যান্ডেলস্টিক প্যাটার্ন মাস্টারি</li>
                            <li>সাপোর্ট ও রেজিস্ট্যান্স লেভেল</li>
                            <li>ট্রেন্ড লাইন ও চ্যানেল ড্রয়িং</li>
                            <li>প্রধান ইন্ডিকেটরস: RSI, MACD, MA, Bollinger Bands</li>
                            <li>ফিবোনাচি রিট্রেসমেন্ট</li>
                            <li>ভলিউম এনালাইসিস</li>
                            <li>টাইমফ্রেম সিলেকশন ও মাল্টি-টাইমফ্রেম এনালাইসিস</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৪: প্রাইস অ্যাকশন ও সিক্রেট স্ট্র্যাটেজি</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>প্রাইস অ্যাকশন কী এবং কেন শক্তিশালী</li>
                            <li>পিন বার, এনগালফিং, ডোজি প্যাটার্ন</li>
                            <li>ব্রেকআউট ট্রেডিং স্ট্র্যাটেজি</li>
                            <li>পুলব্যাক ও রিটেস্ট ট্রেডিং</li>
                            <li>স্কালপিং টেকনিক (স্বল্পমেয়াদী লাভ)</li>
                            <li>সুইং ট্রেডিং কৌশল (মধ্যমেয়াদী)</li>
                            <li>সিক্রেট এন্ট্রি ও এক্সিট পয়েন্ট</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৫: ফিউচার ট্রেডিং মাস্টারক্লাস</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>ফিউচার ট্রেডিং কী ও কিভাবে কাজ করে</li>
                            <li>লিভারেজ কী এবং কিভাবে ব্যবহার করবেন</li>
                            <li>লং ও শর্ট পজিশন</li>
                            <li>মার্জিন ও ফান্ডিং রেট</li>
                            <li>লিকুইডেশন এড়ানোর কৌশল</li>
                            <li>হেজিং স্ট্র্যাটেজি</li>
                            <li>ফিউচার ট্রেডিং রিস্ক ম্যানেজমেন্ট</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৬: মানি ম্যানেজমেন্ট ও রিস্ক কন্ট্রোল</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>মানি ম্যানেজমেন্ট এর গুরুত্ব</li>
                            <li>রিস্ক-রিওয়ার্ড রেশিও (1:2, 1:3)</li>
                            <li>পজিশন সাইজিং ক্যালকুলেশন</li>
                            <li>স্টপ-লস কোথায় এবং কেন সেট করবেন</li>
                            <li>টেক-প্রফিট স্ট্র্যাটেজি</li>
                            <li>পোর্টফোলিও ডাইভারসিফিকেশন</li>
                            <li>মার্কেট ক্র্যাশে সারভাইভ করার কৌশল</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৭: মাল্টি-প্ল্যাটফর্ম ট্রেডিং (ইটোরো ও এক্সনেস)</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>ইটোরো প্ল্যাটফর্ম ইন্ট্রোডাকশন</li>
                            <li>ইটোরো তে কপি ট্রেডিং</li>
                            <li>এক্সনেস প্ল্যাটফর্ম সেটআপ</li>
                            <li>ফরেক্স ও কমোডিটি ট্রেডিং বেসিক</li>
                            <li>MT4/MT5 প্ল্যাটফর্ম গাইড</li>
                            <li>মাল্টি-প্ল্যাটফর্ম পোর্টফোলিও ম্যানেজমেন্ট</li>
                        </ul>
                    </div>
                </div>

                <div class="module-item">
                    <div class="module-header">
                        <span>মডিউল ৮: প্রিমিয়াম ট্রেডিং সিগন্যাল ও লাইফটাইম সাপোর্ট</span>
                        <span class="module-toggle">▼</span>
                    </div>
                    <div class="module-content">
                        <ul>
                            <li>প্রিমিয়াম সিগন্যাল গ্রুপ অ্যাক্সেস</li>
                            <li>ডেইলি ট্রেডিং সিগন্যাল</li>
                            <li>মার্কেট আপডেট ও নিউজ এনালাইসিস</li>
                            <li>বিশেষজ্ঞ ট্রেডারদের সাথে লাইভ সেশন</li>
                            <li>১:১ মেন্টরশিপ ও পোর্টফোলিও রিভিউ</li>
                            <li>ট্রেডিং সাইকোলজি ও ডিসিপ্লিন</li>
                            <li>লাইফটাইম কমিউনিটি সাপোর্ট</li>
                        </ul>
                    </div>
                </div>
            </div>

            <p style="margin-top: 2rem; text-align: center; color: #6b7280; font-style: italic;">
                এই কোর্স নিয়মিত আপডেট করা হয় নতুন স্ট্র্যাটেজি ও মার্কেট ট্রেন্ড অনুযায়ী।
            </p>
        </section>

        <!-- Program Includes -->
        <section class="section section-alt">
            <div class="section-header">
                <span class="section-badge">বোনাস</span>
                <h2>বিশেষ বোনাস ও সুবিধা</h2>
            </div>

            <div class="info-box">
                <h3>✅ প্রিমিয়াম সিগন্যাল গ্রুপ — ফ্রি</h3>
                <ul>
                    <li>ডেইলি ট্রেডিং সিগন্যাল সহ এক্সক্লুসিভ গ্রুপ অ্যাক্সেস</li>
                    <li>মার্কেট আপডেট ও এনালাইসিস</li>
                    <li>প্রফিটেবল ট্রেড আইডিয়া শেয়ারিং</li>
                    <li>সরাসরি বিশেষজ্ঞদের সাথে আলোচনা</li>
                </ul>
            </div>

            <div class="info-box highlight-box">
                <h3>⚡ ট্রেডিং টুলস ও রিসোর্স</h3>
                <ul>
                    <li>পজিশন সাইজ ক্যালকুলেটর টুল</li>
                    <li>রিস্ক-রিওয়ার্ড ক্যালকুলেটর</li>
                    <li>প্রিমিয়াম ট্রেডিং টেমপ্লেট</li>
                    <li>মার্কেট সেন্টিমেন্ট ইন্ডিকেটর গাইড</li>
                    <li>নিয়মিত কোর্স আপডেট ও নতুন মডিউল</li>
                </ul>
            </div>
        </section>

        <!-- Who Should Join -->
        <section class="section">
            <div class="section-header">
                <span class="section-badge">কাদের জন্য</span>
                <h2>কারা জয়েন করবেন?</h2>
            </div>
            
            <div class="learn-grid">
                <div class="learn-item">
                    <span class="learn-icon">💵</span>
                    <span>যারা ঘরে বসে নিয়মিত আয় করতে চান</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">🎓</span>
                    <span>শিক্ষার্থী ও চাকরিজীবী যারা এক্সট্রা ইনকাম চান</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">💼</span>
                    <span>নতুন ট্রেডার যারা সঠিক গাইডলাইন চান</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">📈</span>
                    <span>অভিজ্ঞ ট্রেডার যারা প্রফিট বাড়াতে চান</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">🌐</span>
                    <span>উদ্যোক্তা যারা ক্রিপ্টো ইনভেস্টমেন্ট করতে চান</span>
                </div>
                <div class="learn-item">
                    <span class="learn-icon">🔮</span>
                    <span>যারা ফাইন্যান্সিয়াল ফ্রিডম অর্জন করতে চান</span>
                </div>
            </div>
        </section>

        <!-- What You'll Get -->
        <section class="section section-alt">
            <div class="section-header">
                <span class="section-badge">ফলাফল</span>
                <h2>কোর্স শেষে যা পাবেন</h2>
            </div>
            
            <div class="features-grid features-slider" id="featuresSlider3">
                <div class="feature-card">
                    <div class="feature-icon">💰</div>
                    <h4>১০-১৫%+ মাসিক রিটার্ন</h4>
                    <p>নিয়মিত প্রফিট করার দক্ষতা অর্জন</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🎯</div>
                    <h4>প্রফেশনাল ট্রেডিং</h4>
                    <p>স্পট ও ফিউচার ট্রেডিং মাস্টারি</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🔐</div>
                    <h4>রিস্ক ম্যানেজমেন্ট</h4>
                    <p>মার্কেট ক্র্যাশেও পোর্টফোলিও সুরক্ষা</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">👥</div>
                    <h4>প্রিমিয়াম কমিউনিটি</h4>
                    <p>লাইফটাইম সিগন্যাল গ্রুপ অ্যাক্সেস</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🚀</div>
                    <h4>ফাইন্যান্সিয়াল ফ্রিডম</h4>
                    <p>পার্ট-টাইম বা ফুল-টাইম ক্যারিয়ার</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">📈</div>
                    <h4>প্র্যাকটিক্যাল নলেজ</h4>
                    <p>লাইভ ট্রেড এনালাইসিস ও গাইডেন্স</p>
                </div>
            </div>
            <div class="slider-dots" id="sliderDots3">
                <span class="dot active"></span>
                <span class="dot"></span>
                <span class="dot"></span>
                <span class="dot"></span>
                <span class="dot"></span>
                <span class="dot"></span>
            </div>
        </section>

        <!-- Community & Support -->
        <section class="section">
            <div class="section-header">
                <span class="section-badge">সাপোর্ট</span>
                <h2>কমিউনিটি, সাপোর্ট ও মেন্টরশিপ</h2>
            </div>
            
            <div class="features-grid features-slider" id="featuresSlider4">
                <div class="feature-card glass-card">
                    <div class="feature-number">ডেইলি</div>
                    <h4>ট্রেডিং সিগন্যাল</h4>
                    <p>প্রিমিয়াম গ্রুপে নিয়মিত সিগন্যাল</p>
                </div>
                <div class="feature-card glass-card">
                    <div class="feature-number">১:১</div>
                    <h4>মেন্টরশিপ</h4>
                    <p>বিশেষজ্ঞ ট্রেডার থেকে সরাসরি সাপোর্ট</p>
                </div>
                <div class="feature-card glass-card">
                    <div class="feature-icon">💼</div>
                    <h4>লাইফটাইম অ্যাক্সেস</h4>
                    <p>কোর্স আপডেট ও কমিউনিটি সাপোর্ট</p>
                </div>
            </div>
            <div class="slider-dots" id="sliderDots4">
                <span class="dot active"></span>
                <span class="dot"></span>
                <span class="dot"></span>
            </div>
        </section>

        <!-- FAQ Section -->
        <section class="section section-alt" id="faq">
            <div class="section-header">
                <span class="section-badge">প্রশ্নোত্তর</span>
                <h2>সাধারণ জিজ্ঞাসা</h2>
            </div>
            
            <div class="faq-container">
                <div class="faq-item">
                    <button class="faq-question">
                        <span>১. Crypto Trading শিখতে কত টাকা লাগবে?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>ট্রেডিং শুরু করতে মাত্র $১০ থেকে শুরু করতে পারবেন। তবে ভালো প্রফিট পেতে হলে $৫০-$১০০ দিয়ে শুরু করা ভালো।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>২. পেমেন্ট করার পর কিভাবে অ্যাক্সেস পাবো?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>পেমেন্ট সম্পন্ন হওয়ার সাথে সাথে কোর্স অ্যাক্সেস লিংক এবং প্রিমিয়াম সিগন্যাল গ্রুপের লিংক পাবেন আপনার ইমেইল ও হোয়াটসঅ্যাপে।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৩. ট্রেডিং কি ঝুঁকিপূর্ণ নয়?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>যেকোনো ব্যবসায় ঝুঁকি আছে। তবে সঠিক মানি ম্যানেজমেন্ট ও রিস্ক কন্ট্রোল শিখলে এই ঝুঁকি অনেক কমে যায়। আমাদের কোর্সে রিস্ক ম্যানেজমেন্ট বিশেষভাবে শেখানো হয়।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৪. প্রতিদিন কত সময় দিতে হবে?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>কোর্স শিখতে দৈনিক ১-২ ঘণ্টা দিলেই যথেষ্ট। ট্রেড করতে প্রতিদিন ৩০ মিনিট থেকে ২ ঘণ্টা সময় দিতে পারেন আপনার সুবিধামত।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৫. বাংলাদেশ থেকে কি Binance ব্যবহার করা যায়?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>হ্যাঁ, সম্পূর্ণ লিগ্যাল! Binance বাংলাদেশে সম্পূর্ণ বৈধভাবে ব্যবহার করা যায়। লাখ লাখ বাংলাদেশি ট্রেডার ব্যবহার করছেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৬. কোর্স করতে গিয়ে যদি সমস্যা হয় তাহলে সাহায্য পাওয়া যাবে?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>হ্যাঁ, নিশ্চিত! আমাদের প্রিমিয়াম কমিউনিটিতে ২৪/৭ সাহায্য পাবেন এবং প্রতি সপ্তাহে লাইভ সাপোর্ট সেশন পাবেন। এছাড়াও ১:১ মেন্টরশিপ পাবেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৭. ফিউচার ট্রেডিং কি নতুনদের জন্য উপযুক্ত?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>ফিউচার ট্রেডিং শুরুতে ঝুঁকিপূর্ণ মনে হলেও আমরা স্টেপ বাই স্টেপ শেখাই। প্রথমে স্পট ট্রেডিং শিখবেন, তারপর ফিউচারে যাবেন। সঠিক গাইডেন্স পেলে নতুনরাও নিরাপদে ফিউচার ট্রেডিং করতে পারবেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৮. আমি একেবারে নতুন, কোনো অভিজ্ঞতা নেই। তাও কি শুরু করতে পারব?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>বিলকুল! কোর্সটি একদম বেসিক থেকে শুরু করে অ্যাডভান্স লেভেল পর্যন্ত ডিজাইন করা। আমরা ধরে নিয়েছি আপনার কোনো পূর্ব অভিজ্ঞতা নেই। শুরু থেকে শেষ পর্যন্ত স্টেপ বাই স্টেপ শেখাব।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>৯. কোর্স কি লাইভ নাকি রেকর্ডেড?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>কোর্স মূলত রেকর্ডেড ভিডিও যাতে আপনি যেকোনো সময় শিখতে পারেন। পাশাপাশি প্রতি সপ্তাহে লাইভ ট্রেডিং সেশন ও QnA সেশন থাকবে।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১০. প্রিমিয়াম সিগন্যাল গ্রুপে কি থাকবে?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>প্রিমিয়াম সিগন্যাল গ্রুপে প্রতিদিন ট্রেডিং সিগন্যাল, মার্কেট এনালাইসিস, এক্সপার্ট ট্রেডারদের লাইভ ট্রেড শেয়ার এবং সবার সাথে আলোচনার সুযোগ পাবেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১১. কোর্স শেষে কি সার্টিফিকেট পাবো?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>হ্যাঁ! কোর্স সফলভাবে সম্পন্ন করলে প্রাইম ইনস্টিটিউট থেকে ডিজিটাল সার্টিফিকেট পাবেন যা আপনার পোর্টফোলিওতে যুক্ত করতে পারবেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১২. মানি ব্যাক গ্যারান্টি আছে কি?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>হ্যাঁ! কোর্সে এনরোল করার পর যদি ৭ দিনের মধ্যে মনে হয় কোর্সটি আপনার জন্য নয়, তাহলে ১০০% টাকা ফেরত পাবেন। কোনো প্রশ্ন করা হবে না।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১৩. প্রতি মাসে কত টাকা আয় করা সম্ভব?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>এটা নির্ভর করে আপনার ক্যাপিটাল ও ডেডিকেশনের উপর। আমাদের স্ট্র্যাটেজি অনুসরণ করলে মাসে ১০-১৫% রিটার্ন সম্ভব। যেমন $১০০০ ক্যাপিটাল থাকলে মাসে $১০০-$১৫০ আয় করতে পারবেন।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১৪. বয়স কি ব্যাপার? আমার বয়স কম/বেশি, শিখতে পারবো?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>বয়স কোনো ব্যাপার নয়! ১৮ থেকে ৬০ বছর বয়সী মানুষ ট্রেডিং শিখছেন এবং সফল হচ্ছেন। শুধু শেখার আগ্রহ ও ডেডিকেশন থাকলেই যথেষ্ট।</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        <span>১৫. কোর্স অ্যাক্সেস কি লাইফটাইম?</span>
                        <span class="faq-toggle">▼</span>
                    </button>
                    <div class="faq-answer">
                        <p>হ্যাঁ, একবার পেমেন্ট করলে লাইফটাইম অ্যাক্সেস পাবেন। কোর্সের সকল আপডেট, নতুন মডিউল এবং প্রিমিয়াম কমিউনিটি অ্যাক্সেস চিরকালের জন্য পাবেন।</p>
                    </div>
                </div>

            </div>
        </section>

       <!-- Pricing Section -->
        <section class="section" id="pricing">
            <div class="section-header">
                <span class="section-badge">প্রাইসিং</span>
                <h2>আজই কোর্সে যোগ দিন</h2>
            </div>
            
            <div class="pricing-container">
                <span class="pricing-badge">🔥 সীমিত সময়ের অফার</span>
                <h3 style="margin-bottom: 0.5rem; position: relative; z-index: 1;">কোর্স ফি</h3>
                <div class="original-price">৳25,000</div>
                <div class="price-tag">৳9,990</div>
                <p style="position: relative; z-index: 1; opacity: 0.9;">একবার পেমেন্ট, লাইফটাইম অ্যাক্সেস</p>
                
                <ul class="price-benefits">
                    <li>৫০+ রেকর্ডেড ভিডিও ক্লাস</li>
                    <li>প্রিমিয়াম ট্রেডিং সিগন্যাল গ্রুপ (মূল্য ৳5,000/মাস)</li>
                    <li>লাইভ ট্রেডিং সেশন</li>
                    <li>১:১ মেন্টরশিপ সাপোর্ট</li>
                    <li>ট্রেডিং টুলস ও ক্যালকুলেটর</li>
                    <li>লাইফটাইম কমিউনিটি অ্যাক্সেস</li>
                    <li>১০০% মানি ব্যাক গ্যারান্টি (৭ দিন)</li>
                </ul>

                <div style="margin-top: 2rem; padding: 1.25rem; background: rgba(255, 255, 255, 0.1); border-radius: 12px; position: relative; z-index: 1;">
                    <p style="margin: 0; font-size: 0.95rem;">
                        ⏰ <strong>অফার শেষ হওয়ার সময়:</strong> সীমিত সময় বাকি! এরপর দাম বেড়ে ৳25,000 হয়ে যাবে।
                    </p>
                </div>
            </div>

            <!-- Timer -->
            <div class="timer" id="countdown-timer">
                <div class="timer-item">
                    <div class="timer-value" id="timer-days">13</div>
                    <div class="timer-label">দিন</div>
                </div>
                <div class="timer-item">
                    <div class="timer-value" id="timer-hours">04</div>
                    <div class="timer-label">ঘণ্টা</div>
                </div>
                <div class="timer-item">
                    <div class="timer-value" id="timer-minutes">00</div>
                    <div class="timer-label">মিনিট</div>
                </div>
                <div class="timer-item">
                    <div class="timer-value" id="timer-seconds">00</div>
                    <div class="timer-label">সেকেন্ড</div>
                </div>
            </div>

            <!-- Enrollment Form -->
            <form class="enrollment-form" id="enrollmentForm" method="POST" action="process_order.php" onsubmit="trackLead()">
                <h3 style="margin-top: 0; text-align: center; margin-bottom: 1.5rem;">📝 তথ্য দিয়ে জয়েন করুন</h3>
                
                <div class="form-group">
                    <label for="name">নাম *</label>
                    <input type="text" id="name" name="name" placeholder="আপনার নাম লিখুন" required>
                </div>

                <div class="form-group">
                    <label for="email">ইমেইল *</label>
                    <input type="email" id="email" name="email" placeholder="আপনার ইমেইল লিখুন" required>
                </div>

                <div class="form-group">
                    <label for="phone">মোবাইল নম্বর *</label>
                    <input type="tel" id="phone" name="phone" placeholder="01XXXXXXXXX" required>
                </div>

                <div class="form-group">
                    <label for="coupon">কুপন কোড (যদি থাকে)</label>
                    <input type="text" id="coupon" name="coupon" placeholder="কুপন কোড দিন">
                </div>

                <button type="submit" class="submit-btn">🚀 পেমেন্ট এগিয়ে যান</button>
            </form>

            <div style="margin-top: 2rem; padding: 2rem; background: white; border-radius: 16px; text-align: center; border: 1px solid #e2e8f0;">
                <p style="margin: 0 0 0.75rem 0; color: #64748b;">কিনতে কোনো সমস্যা হলে যোগাযোগ করুন</p>
                <p style="margin: 0;">
                    <a href="https://wa.me/+8801783555564" target="_blank" style="text-decoration: none; display: inline-block;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="#25D366"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/></svg>
                    </a>
                </p>
            </div>
        </section>

        <!-- Comparison Table -->
        <section class="section section-alt">
            <div class="section-header">
                <span class="section-badge">তুলনা</span>
                <h2>আমরা যা দিচ্ছি vs অন্যরা</h2>
                <p class="section-subtitle">কেন আমাদের প্রোগ্রাম ইউনিক?</p>
            </div>

            <table class="comparison-table">
                <thead>
                    <tr>
                        <th>ফিচার</th>
                        <th>আমরা</th>
                        <th>অন্যরা</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>প্রিমিয়াম সিগন্যাল গ্রুপ</td>
                        <td class="check-mark">✓</td>
                        <td class="cross-mark">✗</td>
                    </tr>
                    <tr>
                        <td>লাইফটাইম কমিউনিটি সাপোর্ট</td>
                        <td class="check-mark">✓</td>
                        <td class="cross-mark">✗</td>
                    </tr>
                    <tr>
                        <td>প্রাইস অ্যাকশন ও সিক্রেট স্ট্র্যাটেজি</td>
                        <td class="check-mark">✓</td>
                        <td class="cross-mark">✗</td>
                    </tr>
                    <tr>
                        <td>১:১ মেন্টরশিপ সাপোর্ট</td>
                        <td class="check-mark">✓</td>
                        <td class="cross-mark">✗</td>
                    </tr>
                    <tr>
                        <td>প্র্যাকটিক্যাল ট্রেডিং টুলস</td>
                        <td class="check-mark">✓</td>
                        <td class="cross-mark">✗</td>
                    </tr>
                </tbody>
            </table>
        </section>

        <!-- Call to Action -->
        <section class="section text-center" style="background: var(--gradient-dark); color: white;">
            <div class="section-header">
                <span class="section-badge" style="background: rgba(255,255,255,0.15); color: white;">শেষ সুযোগ</span>
                <h2 style="color: white;">এখনই পদক্ষেপ নিন</h2>
            </div>
            <p style="font-size: 1.15rem; color: rgba(255,255,255,0.8); margin-bottom: 2rem; max-width: 600px; margin-left: auto; margin-right: auto;">
                Crypto Trading শিখুন আর মাসে ১০-১৫%+ রিটার্ন অর্জন করুন।
            </p>
            <button class="cta-button primary" onclick="document.getElementById('pricing').scrollIntoView({behavior:'smooth'})" style="background: white; color: #6366f1;">
                <span>🚀</span> এখনই এনরোল করুন
            </button>
        </section>
    </div>

    <!-- Footer -->
    <footer>
        <div class="footer-container">
            <div class="footer-bottom">
                <p>Copyright ©2025 PrimeIT. All Rights Reserved.</p>
                </p>
            </div>
        </div>
    </footer>

    <!-- Scroll to Top Button -->
    <button id="scrollToTopBtn" style="display: none; position: fixed; bottom: 30px; right: 30px; background: #6366f1; color: white; padding: 10px 15px; border: none; border-radius: 50%; cursor: pointer; font-size: 20px; z-index: 999;">↑</button>

    <script>
    // Facebook Pixel Lead Event Tracking
    function trackLead() {
        if (typeof fbq !== 'undefined') {
            fbq('track', 'Lead', {
                content_name: 'Crypto Trading Course',
                content_category: 'Course Enrollment',
                value: <?php echo PAYMENT_AMOUNT; ?>,
                currency: 'BDT'
            });
        }
        return true; // Allow form submission
    }
    </script>
    
    <script src="script.js"></script>
</body>
</html>
