<?php
session_start();

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'primeito_trade');
define('DB_USER', 'primeito_trade');
define('DB_PASS', 'primeito_trade');

// Site Configuration
define('SITE_NAME', 'Prime Institute');
define('SITE_URL', 'https://trade.primeit.org');
define('ADMIN_URL', SITE_URL . '/primeitadmin');

// Fixed Payment Amount
define('PAYMENT_AMOUNT', 9990);

// Database Connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4", DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Helper Functions
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function generateOrderId() {
    return 'PI' . date('Ymd') . strtoupper(substr(uniqid(), -6));
}

function getSettings($pdo) {
    $stmt = $pdo->query("SELECT * FROM settings LIMIT 1");
    return $stmt->fetch() ?: [];
}

function getActiveGateways($pdo) {
    $stmt = $pdo->query("SELECT * FROM payment_gateways WHERE status = 1 ORDER BY sort_order ASC");
    return $stmt->fetchAll();
}

function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: ' . ADMIN_URL . '/login.php');
        exit;
    }
}

// Flash Messages
function setFlash($type, $message) {
    $_SESSION['flash'] = ['type' => $type, 'message' => $message];
}

function getFlash() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}
?>
