<?php
require_once 'config.php';

$orderId = $_GET['order'] ?? '';

if (empty($orderId)) {
    header('Location: index.php');
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order) {
        header('Location: index.php');
        exit;
    }
    
    $settings = getSettings($pdo);
} catch(PDOException $e) {
    die("Error");
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট সফল - Prime Institute</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '1180786514222470');
    fbq('track', 'PageView');
    <?php if ($order['payment_status'] === 'paid' || $order['payment_status'] === 'completed'): ?>
    fbq('track', 'Purchase', {
        value: <?php echo $order['amount']; ?>,
        currency: 'BDT',
        content_name: 'AI Automation Course',
        content_ids: ['<?php echo $order['order_id']; ?>']
    });
    <?php endif; ?>
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
    <style>
        .success-container {
            max-width: 600px;
            margin: 100px auto 40px;
            padding: 20px;
            text-align: center;
        }
        .success-card {
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        .success-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        .success-title {
            font-size: 2rem;
            color: #10b981;
            margin: 0 0 15px 0;
        }
        .success-message {
            color: #6b7280;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        .order-id-box {
            background: #f0fdf4;
            border: 2px solid #10b981;
            padding: 20px;
            border-radius: 12px;
            margin: 20px 0;
        }
        .order-id-label {
            color: #065f46;
            font-size: 0.9rem;
            margin-bottom: 5px;
        }
        .order-id-value {
            font-size: 1.5rem;
            font-weight: 800;
            color: #047857;
        }
        .home-btn {
            display: inline-block;
            padding: 14px 32px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <img src="logo.png" alt="Prime Institute" class="logo-img">
            </a>
        </div>
    </nav>

    <div class="success-container">
        <div class="success-card">
            <?php if ($order['payment_status'] === 'completed'): ?>
            <div class="success-icon">✅</div>
            <h1 class="success-title">পেমেন্ট সফল হয়েছে!</h1>
            <p class="success-message">
                আপনার অর্ডার সফলভাবে সম্পন্ন হয়েছে। খুব শীঘ্রই আপনার ইমেইলে কোর্স অ্যাক্সেস লিংক পাঠানো হবে।
            </p>
            <?php else: ?>
            <div class="success-icon">⏳</div>
            <h1 class="success-title" style="color: #f59e0b;">পেমেন্ট যাচাই হচ্ছে!</h1>
            <p class="success-message">
                আপনার পেমেন্ট তথ্য সফলভাবে জমা হয়েছে। আমাদের টিম যাচাই করে কনফার্ম করলেই আপনার ইমেইলে কোর্স অ্যাক্সেস লিংক পাঠানো হবে।
            </p>
            <?php endif; ?>
            
            <div class="order-id-box">
                <div class="order-id-label">আপনার অর্ডার আইডি</div>
                <div class="order-id-value"><?php echo htmlspecialchars($order['order_id']); ?></div>
            </div>
            
            <p style="color: #6b7280; font-size: 0.95rem;">
                কোনো সমস্যা হলে এই অর্ডার আইডি দিয়ে আমাদের সাথে যোগাযোগ করুন।
            </p>
            
            <a href="index.php" class="home-btn">🏠 হোম পেজে ফিরে যান</a>
        </div>
    </div>
</body>
</html>
