<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize inputs
    $name = sanitize($_POST['name'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $phone = sanitize($_POST['phone'] ?? '');
    $coupon = sanitize($_POST['coupon'] ?? '');
    
    // Validate required fields
    if (empty($name) || empty($email) || empty($phone)) {
        header('Location: index.php?error=missing_fields');
        exit;
    }
    
    // Generate order ID
    $orderId = generateOrderId();
    
    // Get IP and User Agent
    $ipAddress = $_SERVER['REMOTE_ADDR'] ?? '';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    
    try {
        // Insert order into database
        $stmt = $pdo->prepare("
            INSERT INTO orders (order_id, name, email, phone, coupon_code, amount, ip_address, user_agent, payment_status)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'pending')
        ");
        
        $stmt->execute([
            $orderId,
            $name,
            $email,
            $phone,
            $coupon ?: null,
            PAYMENT_AMOUNT,
            $ipAddress,
            $userAgent
        ]);
        
        // Redirect to payment page
        header('Location: payment.php?order=' . $orderId);
        exit;
        
    } catch(PDOException $e) {
        error_log("Order creation error: " . $e->getMessage());
        header('Location: index.php?error=system_error');
        exit;
    }
} else {
    header('Location: index.php');
    exit;
}
?>
