-- PrimeIT Payment System Database Schema
-- Run this SQL in phpMyAdmin or MySQL CLI

-- Create database for shared hosting
CREATE DATABASE IF NOT EXISTS primeito_trade CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE primeito_trade;

-- Admin Users Table
CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default admin user (password: admin)
INSERT INTO admin_users (username, password) VALUES 
('admin', '$2y$10$qjE83b7t7g2Z3PV/VOYCH.deGW5kGCGxQyHI85pfzYAB.efy3i1l.');

-- Settings Table
CREATE TABLE IF NOT EXISTS settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    facebook_pixel_id VARCHAR(100) DEFAULT NULL,
    facebook_access_token VARCHAR(500) DEFAULT NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default settings
INSERT INTO settings (facebook_pixel_id, facebook_access_token) VALUES ('', '');

-- Payment Gateways Table
CREATE TABLE IF NOT EXISTS payment_gateways (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    type ENUM('automatic', 'manual') DEFAULT 'manual',
    gateway_type VARCHAR(50) DEFAULT NULL COMMENT 'bkash, nagad, rocket, etc.',
    account_number VARCHAR(100) DEFAULT NULL,
    account_name VARCHAR(100) DEFAULT NULL,
    account_type VARCHAR(50) DEFAULT NULL COMMENT 'Personal/Merchant',
    instructions TEXT DEFAULT NULL,
    logo VARCHAR(255) DEFAULT NULL,
    api_username VARCHAR(255) DEFAULT NULL,
    api_password VARCHAR(255) DEFAULT NULL,
    api_app_key VARCHAR(255) DEFAULT NULL,
    api_app_secret VARCHAR(255) DEFAULT NULL,
    is_sandbox TINYINT(1) DEFAULT 1,
    status TINYINT(1) DEFAULT 1,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default bKash gateway
INSERT INTO payment_gateways (name, type, gateway_type, status, sort_order) VALUES 
('bKash', 'automatic', 'bkash', 0, 1);

-- Orders Table
CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id VARCHAR(50) NOT NULL UNIQUE,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    phone VARCHAR(20) NOT NULL,
    coupon_code VARCHAR(50) DEFAULT NULL,
    amount DECIMAL(10,2) NOT NULL,
    payment_gateway_id INT DEFAULT NULL,
    payment_method VARCHAR(50) DEFAULT NULL,
    transaction_id VARCHAR(100) DEFAULT NULL,
    payment_phone VARCHAR(20) DEFAULT NULL,
    payment_status ENUM('pending', 'completed', 'failed', 'refunded') DEFAULT 'pending',
    payment_proof VARCHAR(255) DEFAULT NULL,
    admin_notes TEXT DEFAULT NULL,
    ip_address VARCHAR(45) DEFAULT NULL,
    user_agent TEXT DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (payment_gateway_id) REFERENCES payment_gateways(id) ON DELETE SET NULL
);

-- Coupon Codes Table (Optional for future use)
CREATE TABLE IF NOT EXISTS coupons (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(50) NOT NULL UNIQUE,
    discount_type ENUM('fixed', 'percentage') DEFAULT 'fixed',
    discount_value DECIMAL(10,2) NOT NULL,
    max_uses INT DEFAULT NULL,
    used_count INT DEFAULT 0,
    valid_from DATETIME DEFAULT NULL,
    valid_until DATETIME DEFAULT NULL,
    status TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create indexes for better performance
CREATE INDEX idx_orders_status ON orders(payment_status);
CREATE INDEX idx_orders_created ON orders(created_at);
CREATE INDEX idx_orders_email ON orders(email);
