<?php
require_once 'config.php';

$orderId = $_GET['order'] ?? '';
$gatewayId = intval($_GET['gateway'] ?? 0);

if (empty($orderId) || $gatewayId <= 0) {
    header('Location: index.php');
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    $stmt = $pdo->prepare("SELECT * FROM payment_gateways WHERE id = ?");
    $stmt->execute([$gatewayId]);
    $gateway = $stmt->fetch();
    
    if (!$order || !$gateway) {
        header('Location: index.php');
        exit;
    }
    
    $settings = getSettings($pdo);
} catch(PDOException $e) {
    die("Error loading page");
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transactionId = sanitize($_POST['transaction_id'] ?? '');
    $paymentPhone = sanitize($_POST['payment_phone'] ?? '');
    $paymentProof = null;
    
    // Handle file upload
    if (isset($_FILES['payment_proof']) && $_FILES['payment_proof']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $fileType = $_FILES['payment_proof']['type'];
        $fileSize = $_FILES['payment_proof']['size'];
        
        if (in_array($fileType, $allowedTypes) && $fileSize <= 5 * 1024 * 1024) { // 5MB max
            $extension = pathinfo($_FILES['payment_proof']['name'], PATHINFO_EXTENSION);
            $fileName = $orderId . '_' . time() . '.' . $extension;
            $filePath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['payment_proof']['tmp_name'], $filePath)) {
                $paymentProof = $fileName;
            }
        } else {
            $error = "শুধুমাত্র JPG, PNG, GIF, WEBP ফাইল আপলোড করুন (সর্বোচ্চ 5MB)";
        }
    }
    
    if (!isset($error) && !empty($transactionId) && !empty($paymentPhone)) {
        try {
            $stmt = $pdo->prepare("
                UPDATE orders 
                SET transaction_id = ?, payment_phone = ?, payment_proof = ?, payment_status = 'pending', updated_at = NOW()
                WHERE order_id = ?
            ");
            $stmt->execute([$transactionId, $paymentPhone, $paymentProof, $orderId]);
            
            header('Location: success.php?order=' . $orderId);
            exit;
        } catch(PDOException $e) {
            $error = "পেমেন্ট সাবমিট করতে সমস্যা হয়েছে";
        }
    } elseif (!isset($error)) {
        $error = "সকল তথ্য পূরণ করুন";
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট নির্দেশনা - Prime Institute</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Meta Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '1180786514222470');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Meta Pixel Code -->
    
    <style>
        .manual-payment-container {
            max-width: 700px;
            margin: 80px auto 40px;
            padding: 20px;
        }
        .payment-card {
            background: white;
            border-radius: 16px;
            padding: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 20px;
        }
        .payment-card h2 {
            margin: 0 0 20px 0;
            color: #1f2937;
        }
        .instruction-box {
            background: #f0f9ff;
            border-left: 4px solid #3b82f6;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .instruction-box h3 {
            margin: 0 0 15px 0;
            color: #1e40af;
        }
        .instruction-step {
            margin: 10px 0;
            padding-left: 25px;
            position: relative;
        }
        .instruction-step::before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #10b981;
            font-weight: bold;
        }
        .account-details {
            background: #fef3c7;
            border: 2px dashed #f59e0b;
            padding: 20px;
            border-radius: 12px;
            margin: 20px 0;
            text-align: center;
        }
        .account-details .label {
            color: #92400e;
            font-size: 0.9rem;
            margin-bottom: 5px;
        }
        .account-details .value {
            font-size: 1.5rem;
            font-weight: 800;
            color: #78350f;
            margin: 5px 0;
        }
        .copy-btn {
            background: #f59e0b;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 6px;
            cursor: pointer;
            margin-top: 10px;
        }
        .form-group {
            margin: 15px 0;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #374151;
            font-weight: 500;
        }
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 1rem;
        }
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        .submit-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            margin-top: 20px;
        }
        .error-message {
            background: #fee2e2;
            color: #991b1b;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="index.php" class="logo">
                <img src="logo.png" alt="Prime Institute" class="logo-img">
            </a>
        </div>
    </nav>

    <div class="manual-payment-container">
        <?php if (isset($error)): ?>
        <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <div class="payment-card">
            <h2>💳 <?php echo htmlspecialchars($gateway['name']); ?> পেমেন্ট</h2>
            
            <div class="account-details">
                <div class="label">পেমেন্ট করুন এই নম্বরে</div>
                <div class="value" id="accountNumber"><?php echo htmlspecialchars($gateway['account_number']); ?></div>
                <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($gateway['account_number']); ?>')">
                    📋 কপি করুন
                </button>
                <?php if (!empty($gateway['account_name'])): ?>
                <div style="margin-top: 15px;">
                    <div class="label">অ্যাকাউন্ট নাম</div>
                    <div style="font-weight: 600; color: #78350f;"><?php echo htmlspecialchars($gateway['account_name']); ?></div>
                </div>
                <?php endif; ?>
                <?php if (!empty($gateway['account_type'])): ?>
                <div style="margin-top: 10px;">
                    <div class="label">অ্যাকাউন্ট টাইপ</div>
                    <div style="font-weight: 600; color: #78350f;"><?php echo htmlspecialchars($gateway['account_type']); ?></div>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="instruction-box">
                <h3>📌 পেমেন্ট নির্দেশনা</h3>
                <?php if (!empty($gateway['instructions'])): ?>
                    <div><?php echo nl2br(htmlspecialchars($gateway['instructions'])); ?></div>
                <?php else: ?>
                    <div class="instruction-step">উপরের নম্বরে ৳<?php echo number_format($order['amount'], 0); ?> টাকা পাঠান</div>
                    <div class="instruction-step">লেনদেন সম্পূর্ণ করুন</div>
                    <div class="instruction-step">ট্রানজেকশন আইডি কপি করুন</div>
                    <div class="instruction-step">নিচের ফর্মে তথ্য দিয়ে সাবমিট করুন</div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="payment-card">
            <h2>✅ পেমেন্ট নিশ্চিত করুন</h2>
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>ট্রানজেকশন আইডি / রেফারেন্স নম্বর *</label>
                    <input type="text" name="transaction_id" placeholder="যেমন: 8N254B1X9A" required>
                </div>
                
                <div class="form-group">
                    <label>যে নম্বর থেকে পেমেন্ট করেছেন *</label>
                    <input type="tel" name="payment_phone" placeholder="01XXXXXXXXX" required>
                </div>
                
                <div class="form-group">
                    <label>📷 পেমেন্ট স্ক্রিনশট আপলোড করুন</label>
                    <div class="file-upload-wrapper">
                        <input type="file" name="payment_proof" id="payment_proof" accept="image/*">
                        <div class="file-upload-box" onclick="document.getElementById('payment_proof').click()">
                            <span class="upload-icon">📤</span>
                            <span class="upload-text">ক্লিক করে স্ক্রিনশট সিলেক্ট করুন</span>
                            <span class="upload-hint">JPG, PNG, GIF, WEBP (সর্বোচ্চ 5MB)</span>
                        </div>
                        <div id="preview-container" style="display: none; margin-top: 15px;">
                            <img id="preview-image" style="max-width: 100%; border-radius: 8px; border: 2px solid #10b981;">
                            <p style="color: #10b981; margin-top: 8px;">✓ স্ক্রিনশট সিলেক্ট হয়েছে</p>
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="submit-btn">
                    ✓ পেমেন্ট সম্পন্ন হয়েছে
                </button>
            </form>
        </div>
    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('নম্বর কপি হয়েছে: ' + text);
            });
        }
        
        // File upload preview
        document.getElementById('payment_proof').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-image').src = e.target.result;
                    document.getElementById('preview-container').style.display = 'block';
                    document.querySelector('.file-upload-box').style.borderColor = '#10b981';
                    document.querySelector('.upload-text').textContent = file.name;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
    
    <style>
        .file-upload-wrapper { position: relative; }
        .file-upload-wrapper input[type="file"] { position: absolute; opacity: 0; width: 0; height: 0; }
        .file-upload-box {
            border: 2px dashed #9ca3af;
            border-radius: 12px;
            padding: 30px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #f9fafb;
        }
        .file-upload-box:hover {
            border-color: #667eea;
            background: #f0f4ff;
        }
        .upload-icon { font-size: 40px; display: block; margin-bottom: 10px; }
        .upload-text { display: block; color: #374151; font-weight: 500; margin-bottom: 5px; }
        .upload-hint { display: block; color: #9ca3af; font-size: 0.85rem; }
    </style>
</body>
</html>
